require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../common/cancel_appointment'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'

describe '[STORY# VAR-9703: Display number of available slots after clinic has been selected]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    TITLE = "Appointments/Requests"

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "siteSupportingMissingLocation.json", @db)
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "primaryCareDirectSchedulingNewSettings.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData("1113138327")
    @@timeSlot = "08:00"
    @clinic ="ZZBO MED CLINIC"
    @location = "BOSTON HCS VAMC"
    ## The clinic name is diff in cdw v/s mdws but in real world its same per Chris. We may need to update this test once clinic name
    # for details, list and appointment form is being pulled from same place
    #@clinic = "BOPACTB1"

    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 08:00:00")
    @cancel_appointment.update_appointment_obj("clinicId", "496")
    @cancel_appointment.update_appointment_obj("clinicName", "TESTCLINIC056")
    @cancel_appointment.cancel_appointment()

    deletePatientData("1113138327")
    @common.loginEndsOnHome(pw_redacted)

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-9716|TC#VAR-9717: Display number of available slots after clinic has been selected]' do
    it 'Navigate to Create new appointment details section' do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.selectClinic("32")
      @new_appointment.provideReasonForAppointment("This is new Primary Care Request")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, "11:00")
      @new_appointment.enterEmail("testPC@test.com")
      @new_appointment.selectClinic("444")
      @common.waitWhileSpinnerPresent()
      expect(@new_appointment.reason_element.text).to eq("This is new Primary Care Request")
    end

    it "should verify new clinic list(1) is loaded when 'type of care' is swicthed" do
      @new_appointment.selectNewAppointmentAndSchedule(MENTAL_HEALTH, "523", "523", "direct")
      clinicInfo0 = ["BO C&P MH PSO HOUGH"]
      clinicGroup0 = @new_appointment.clinic_group_elements[0].text.split("\n")
      compareContents(clinicInfo0, clinicGroup0)
    end

    it "should verify new clinic list(2) is loaded when 'type of care' is swicthed" do
      clinicInfo1 = ["BO MH TELEHEALTH PSYCHOPHARM"]
      clinicGroup1 = @new_appointment.clinic_group_elements[1].text.split("\n")
      compareContents(clinicInfo1, clinicGroup1)
    end

    it "should verify new clinic list(3) is loaded when 'type of care' is swicthed" do
      clinicInfo2 = ["ZZBO MED CLINIC"]
      clinicGroup2 = @new_appointment.clinic_group_elements[2].text.split("\n")
      compareContents(clinicInfo2, clinicGroup2)
    end

    it "Verify No available slots pop up modal when clinic with no slots is selected" do
      @new_appointment.selectClinic("17")
      @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle_element.text).to eq "No Available Appointments"
      expect(@modal.content_element.text).to eq 'Unfortunately, there are no available time slots at this clinic. Please select another clinic or change your scheduling method to "Submit a Request to VA Scheduler.”'
    end

    it "Verify selecting clinic loads appointment details options" do
      @modal.buttons_elements[0].click
      @new_appointment.selectClinic("433")
      @new_appointment.provideReasonForAppointment("schedule appointment with a clinic change")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeSlot)
      @new_appointment.enterEmail("testPC@test.com")
      @new_appointment.selectClinic("496")
      @common.waitWhileSpinnerPresent()
      @new_appointment.clickScheduleAppointment
      verifyErrorMessage("Preferred Date field is required.")
    end

    it "Verify select date is required is not displayed" do
      expect(verifyErrorMessage("Select Date/Time field is required.")).to eq(false)
    end


    it "Verify selected slot text is not visible" do
      reason_field = @new_appointment.schedule_appointment_element
      reason_field.scroll.to :top
      expect(@new_appointment.verifySelectedSlotTxt).to eq(false)
    end

    it "should verify Schedule appointment is successfull" do
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeSlot)
      @@setDate = NewAppointmentRequest.bookedDate
      @new_appointment.clickScheduleAppointment
      @common.waitWhileSpinnerPresent()
      @detail.appointment_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it "Should verify Provide Feedback link is displayed on Submission Confirmation page" do
      expect(@detail.feedbackLink_element.text).to eq("Provide feedback on this submission.")
    end

    it "Should verify appointment details for date/time, clinic and Reason for Appointment" do
      @@selectedDay = getDayofWeek(@@setDate)
      @@timeSlot = @@timeSlot.gsub!(':', '')
      expected_text = [\
          "Date and Time:" + " #{@@selectedDay}," + " #{@@setDate}",
          "Date:" + " #{@@selectedDay},"+ " #{@@setDate}",
          @@timeSlot,
          "Time: #{@@timeSlot.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@location}",
          "#{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: schedule appointment with a clinic change"
      ]
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end
    end

  end
end

